﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using BMS.Utils;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Via.Tests
{
    [TestClass]
    public class ViaVistASessionFactoryTest : UnitTestBase
    {
        [TestMethod]
        public void RetrievalMethodTest()
        {
            var target = new ViaVistASessionFactory();
            var method = target.RetrievalMethod;

            Assert.AreEqual(DataRetrievalMethod.VIA, method);
        }

        [TestMethod, RequiresShimsContext]
        public void MakeVistASessionTest()
        {
            var site = new VistASite("id", "name", "number", TimeZoneInfo.Local, "url");

            VistASite recievedSite = null;
            var constructorCalled = false;

            Fakes.ShimViaVistASession.ConstructorVistASite = (x, s) =>
            {
                constructorCalled = true;
                recievedSite = s;
            };

            var target = new ViaVistASessionFactory();
            var session = target.MakeVistASession(site);

            Assert.IsNotNull(session);
            Assert.IsTrue(constructorCalled);
            Assert.AreEqual(site, recievedSite);
        }
    }
}
